#!/bin/sh

DPLY_PAGE_MODE_SELECT_RESULT_OK=0
DPLY_PAGE_MODE_SELECT_RESULT_ERROR=1
DPLY_PAGE_MODE_SELECT_RESULT_CODE=${DPLY_PAGE_MODE_SELECT_RESULT_ERROR}

DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=0
DPLY_PAGE_MODE_SELECT_RESULT_MSG=""

dply_page_mode_select() {
	debug_print "${BASH_SOURCE[1]}" "${BASH_LINENO[0]}" 'in function "dply_page_mode_select"'
	
	tp_yesno \
		"${DPLY_PAGE_MODE_SELECT_TITLE}" \
		"${DPLY_PAGE_MODE_SELECT_TEXT}" \
		"${DPLY_PAGE_MODE_SELECT_LABEL_OK}" \
		"${DPLY_PAGE_MODE_SELECT_LABEL_CANCEL}"

    # debug_print "${0}" "${LINENO}" "TP_YESNO_RESULT_CODE: ${TP_YESNO_RESULT_CODE}"
    case "${TP_YESNO_RESULT_CODE}" in
    
        "${TP_YESNO_RESULT_ERROR}" )
            DPLY_PAGE_MODE_SELECT_RESULT_CODE=$DPLY_PAGE_MODE_SELECT_RESULT_ERROR
            DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_MODE_SELECT_RESULT_MSG="${DPLY_PAGE_MODE_SELECT_ERROR_UNKNOWN}"
            return
            ;;
            
        "${TP_YESNO_RESULT_OK}" )
            ;;
            
        * )
            DPLY_PAGE_MODE_SELECT_RESULT_CODE=$DPLY_PAGE_MODE_SELECT_RESULT_ERROR
            DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=0
            DPLY_PAGE_MODE_SELECT_RESULT_MSG="${DPLY_PAGE_MODE_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    debug_print "${0}" "${LINENO}" "TP_YESNO_RESULT_SELECT: ${TP_YESNO_RESULT_SELECTS}"
	case "${TP_YESNO_RESULT_SELECT}" in
	
		# user select "Master"
		"${TP_YESNO_RESULT_YES}")
			RT_MASTER_MODE=1
			;;
		
		# user select "Cluster"
		"${TP_YESNO_RESULT_NO}")
			RT_MASTER_MODE=0
			;;
			
		*)
			DPLY_PAGE_MODE_SELECT_RESULT_CODE=$DPLY_PAGE_MODE_SELECT_RESULT_ERROR
			DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=0
			DPLY_PAGE_MODE_SELECT_RESULT_MSG="${DPLY_PAGE_MODE_SELECT_ERROR_UNKNOWN}"
			return
            ;;
	esac
	
	# save and error handling
	utility_save_infra_conf "${RT_MASTER_MODE}"
	if [ "${?}" -ne 0 ]; then
		DPLY_PAGE_MODE_SELECT_RESULT_CODE=$DPLY_PAGE_MODE_SELECT_RESULT_ERROR
		DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=0
		DPLY_PAGE_MODE_SELECT_RESULT_MSG="${DPLY_PAGE_MODE_SELECT_ERROR_SAVE_CONFIGURATION}"
		return 
	fi
	
	# save successfully
	DPLY_PAGE_MODE_SELECT_RESULT_CODE=$DPLY_PAGE_MODE_SELECT_RESULT_OK
	DPLY_PAGE_MODE_SELECT_RESULT_ROLLING=1
	DPLY_PAGE_MODE_SELECT_RESULT_MSG=""
}
